﻿
//This function is called after Selected Index Change of Domain
function SetDomainParameters() {

    var ddlDomain = document.getElementById("ddlDomain");
    var SelValue = ddlDomain.options[ddlDomain.selectedIndex].value;
    var SelText = ddlDomain.options[ddlDomain.selectedIndex].text;

    var ItemsCount = $("#ddlDomain option").length;
    var SelIndex = $("#ddlDomain option:selected").index();

    $('#hdnDomainId').val(SelValue);
    $('#hdnDomainName').val(SelText);
    $('#hdnDomainItemsCount').val(ItemsCount);
    $('#hdnDomainSelIndex').val(SelIndex);
}

//Calling Syncfusion Reporviewer for Rendering PDF
function AddTab(ReportFilter, ReportName, tabId, Clsvariable) {

    var EsignLogId = 0;
    var formdata = ReportFilter;
    var currentDate = Clsvariable.currentDate;
    if (ReportName == "")
        ReportName = "Report_" + currentDate;
    $("#PrintDateTime").val(currentDate);

    var EsignApplicable = 'N';
    var LiID = (document.getElementsByClassName("tabItem").length) + 1;
    var EsignLevel = null; var EsignMaxLevel = null; boolPrint = true;

    var strformdata = encodeURIComponent(JSON.stringify(formdata));
    $.ajax({
        url: '/PdfViewer/GetPdfDocument',
        type: "POST",
        data: JSON.stringify(formdata),
        dataType: 'text',
        crossDomain: true,
        traditional: true,
        contentType: "application/json;base64 ",
        beforeSend: function () {
            $('.loader').show();
        },
        success: function (ResponseData) {

            var response = JSON.parse(ResponseData);
            /* Initalizing viewer */
            var viewer;
            var arrtoolbarItems = [];
            arrtoolbarItems.push('MagnificationTool');
            arrtoolbarItems.push('PanTool');
            arrtoolbarItems.push('SelectionTool');
            arrtoolbarItems.push('PageNavigationTool');
            arrtoolbarItems.push('SearchOption');
            if (Clsvariable.AllowPrint == 'Y')
                arrtoolbarItems.push('PrintOption');
            if (Clsvariable.AllowSave == 'Y')
                arrtoolbarItems.push('DownloadOption');
            if (Clsvariable.ValidatePrint == 'Y') {
                if (response.ReportEsign != null) {

                    if (response.ReportEsign != "")
                        EsignApplicable = response.ReportEsign;
                    if (EsignApplicable == "Y") {
                        if (response.Data == '' && response.Data.length == 0) {
                            boolPrint = false;
                        }
                        else {
                            if (response.Data[0].LoginName_L1 == "")
                                boolPrint = false;
                            if (response.Data[0].ESignLevel > 1) {
                                if (response.Data[0].LoginName_L2 == "") {
                                    boolPrint = false;
                                }
                            }
                            if (response.Data[0].ESignLevel > 2) {
                                if (response.Data[0].LoginName_L3 == "") {
                                    boolPrint = false;
                                }
                            }
                        }
                    }

                }
            }
            viewer = new ej.pdfviewer.PdfViewer({
                enableThumbnail: true,
                enableBookmark: false,
                enablePageOrganizer: false,
                enableHyperlink: false,
                enableFormDesigner: false,
                serviceUrl: '/PdfViewer',
                fitToWidth: true,
                fitToPage: true,
                documentPath: response.Datapdf,

                toolbarSettings: {
                    showTooltip: true, toolbarItems: arrtoolbarItems
                }
            });
            ej.pdfviewer.PdfViewer.Inject(ej.pdfviewer.TextSelection, ej.pdfviewer.TextSearch, ej.pdfviewer.Print, ej.pdfviewer.Navigation);
            if (response == '')
                alert('There is a problem exporting the file');
            else {

                if (response.Data != null) {
                    if (response.Data != '' && response.Data.length > 0) {
                        EsignLogId = response.Data[0].ESignatureLogId;
                        EsignLevel = response.Data[0].ESignLevel;
                        EsignMaxLevel = response.Data[0].Max_ESignLevel;;
                    }
                }
                if (response.ReportEsign != null) {
                    if (response.ReportEsign != "")
                        EsignApplicable = response.ReportEsign;
                }
                //Appending Li to UL For New Tab

                $("#UlTab").append('<li id="li_' + LiID + '" class="nav-item tabItem"><a class="nav-link" id="anc_' + LiID + '" data-toggle="tab" href="#div_' + LiID + '" role="tab" aria-controls="div_' + LiID + '" aria-selected="false">Tab ' + LiID + '<button type="button" name="btnClose" onclick="RemoveLi(' + LiID + ')"><i class="far fa-times-circle"></i></button></a> </li>');
                $('#myTabContent').append('<div class="tab-pane fade" id="div_' + LiID + '" role="tabpanel" aria-labelledby="Anc_' + LiID + '"></div>')

                $('#div_' + LiID).append('<div id="container" style="width:100%"><input type="hidden" id="hdnPdf_' + LiID + '" name="hdnPdf_' + LiID + '" value="' + strformdata + '" /><input type="hidden" id="hdnPdfReportName_' + LiID + '" value="' + ReportName + '" /><input type="hidden" id="hdnPdfEsignLogId_' + LiID + '" value="' + EsignLogId + '" /><input type="hidden" id="hdnPdfEsignLevel_' + LiID + '" value="' + EsignLevel + '" /><input type="hidden" id="hdnPdfEsignMaxLevel_' + LiID + '" value="' + EsignMaxLevel + '" /><div id="divPdf_' + LiID + '" style="height: 650px;min-height:404px; justify-content: center;" ></div></div>');
                viewer.initialRenderPages = 2;
                viewer.appendTo('#divPdf_' + LiID);

                viewer.downloadStart = function (args) {

                    args.cancel = true; // Prevent download action
                    //viewer.properties.downloadFileName = ReportName;
                };
                viewer.printStart = function (args) {
                    if (boolPrint == false) {
                        alert("WITHOUT E-SIGNATURE PRINT / SAVE NOT ALLOWED")
                        args.cancel = true; // Prevent Print action
                    }
                }
                viewer.ajaxRequestInitiate = function (args) {
                    if (args.JsonData.action == "Download") {
                        args.JsonData['hdnEntityData'] = JSON.stringify(formdata);
                        args.JsonData['returnmsg'] = "";
                        viewer.setJsonData(args.JsonData);
                    }
                };
                //viewer.ajaxRequestSuccess = function (args) {
                //};
                viewer.pageChange = function (args) {
                    UserActivity();
                };
                viewer.zoomChange = function (args) {
                    UserActivity();
                };
                viewer.serverActionSettings.download = "SaveDocument";
                viewer.downloadEnd = function (args) {
                    pdfstream = args.downloadDocument;
                    //Print the document as a base64 string in the console window.
                    alert("File Saved Successfully.You can view the Saved file in Saved Reports Menu");
                };
                // viewer.download();
                // viewer.serverActionSettings.download = "Download";
                //  viewer.documentLoad = function (args) {



                // };


            }

        },
        failure: function (data) {
            alert("Cannot export the file: Error in calling Ajax");
        },
        error: function (data) {
            console.log('ERROR: ', data);
        },
        complete: function (jqXHR, textStatus) {
            //If Tab is Created from Approval Process hides existing ReportViewer Tab
            if (tabId != null) {
                $('#li_' + tabId).hide();
                $('#div_' + tabId).hide();
                $("#EsignModalPopup").modal('hide');
            }
            $('#anc_' + LiID).click();
            $('.loader').hide();
            $("#divPdf_" + LiID + "_downloadIcon").html("<i class='fa fa-save' style='font-size: 15px;'></i>");
            $("#divPdf_" + LiID + "_downloadIcon").attr('class', 'e-pv-icon e-icon-left');
            $("#divPdf_" + LiID + "_downloadIcon").attr('ariaLabel', 'Save file (Ctrl+S)');
            $("#divPdf_" + LiID + "_download").attr('aria-label', 'Save file (Ctrl+S)');
            //Adding Esign Button on ReportViewer

            if (EsignApplicable == "Y") {
                //This is Code is Written for Handling Visibility of Esign Button
                if (EsignLevel != EsignMaxLevel || EsignLevel == null) {
                    var toolbar = $("#divPdf_" + LiID)[0].firstElementChild.firstElementChild.firstElementChild;
                    var toolbarRight = $("#divPdf_" + LiID).find('.e-toolbar-right')
                    var role = $(toolbar).attr("role");
                    if (role == "toolbar") {
                        //Appends the custom button to default toolbar
                        // $(toolbarRight).append($('<div class="e-toolbar-item e-tbtn-align e-pv-text-search-container e-popup-text" title="@localizer.Get("Esignature")" id="divPdf_'+LiID+'_Esignature"><button type="button" class="btn btn-primary" id="btnPdfEsign_'+LiID+'"  style="float:right;background-color: green;" onclick="OpenEsignModal(this)" title="Esignature">@localizer.Get("Esignature") <i class="fas fa-file-signature"></i></button></div>'));
                        $(toolbarRight).append($('<div class="e-toolbar-item e-tbtn-align e-pv-text-search-container e-popup-text" title="Esignature" id="divPdf_' + LiID + '_Esignature"><a href="#" id="btnPdfEsign_' + LiID + '" class="e-tbar-btn e-tbtn-txt e-control e-btn e-lib  e-pv-tbar-btn e-tooltip" style="float:right;" onclick="OpenEsignModal(this)" title="Esignature"> <i class="fas fa-file-signature"></i></a></div>'));
                    }
                }
            }

        }
    });

}

function RemoveLi(objid) {

    $('#li_' + objid).remove();
    $('#div_' + objid).remove();
    $('#ancReportTab').click();
}
function Save_ApproveEsign(Clsvariable) {
    var txtComment = ''; var ddlComment = '';
    var obj = {};
    var commentCategorylevel = Clsvariable.commentCategorylevel;

    if ($('#ddlComment') != null) {
        ddlComment = $('#ddlComment').val();
    }
    if ($('#txtComment') != null) {
        txtComment = $('#txtComment').val();
    }
    if ($('#ddlDomain').val() == '') {
        $('#ddlDomain')[0].reportValidity();
        return false;
    }
    else if ($('#LoginName').val() == '') {
        $('#LoginName')[0].reportValidity();
        return false;
    }
    else if ($('#Loginpassword').val() == '') {
        $('#Loginpassword')[0].reportValidity();
        return false;
    }
    else if (commentCategorylevel == 3 && (txtComment == '' || ddlComment == ''))//dropdown and txtComment
    {
        alert(Clsvariable.CommentandUserComment);
        //  $('#txtComment')[0].reportValidity();
        return false;
    }
    else if (commentCategorylevel == 2 && (txtComment == '' && ddlComment == ''))//dropdown and txtComment
    {
        alert(Clsvariable.CommentORUserComment);
        return false;
    }

    else if (commentCategorylevel == 1 && ddlComment == '')//dropdown
    {
        alert(Clsvariable.Comment_Required);
        return false;
    }
    else if (commentCategorylevel == 0 && txtComment == '')// txtComment
    {
        alert(Clsvariable.UserComment_Required);
        return false;
    }
    else {
        var SuccessStatus;
        var EsingnTabId = $('#EsigntabId').val();
        var formdata = JSON.parse(decodeURIComponent($("#hdnPdf_" + EsingnTabId).val()));
        var EsignLogId = $("#hdnPdfEsignLogId_" + EsingnTabId).val();
        var Esigndata = [];
        var obj = {};
        var auth = btoa($('#hdnUserName').val() + ':' + $('#hdnPassword').val());
        obj.Domain = $('#ddlDomain').val();
        obj.LoginName = $('#LoginName').val();
        obj.Loginpassword = $('#Loginpassword').val();
        obj.ApplicationUserGroup = Clsvariable.ApplicationUserGroup;
        obj.ApplicationUserName = Clsvariable.ApplicationUserName;
        obj.DomainId = $('#hdnDomainId').val();
        obj.DomainName = $('#hdnDomainName').val();
        obj.DomainItemsCount = $('#hdnDomainItemsCount').val();
        obj.CommentText = txtComment;
        obj.CommentSelectedValue = ddlComment;
        obj.CommentSelectedText = $("option:selected", $("#ddlComment")).text();
        obj.EsignLogId = EsignLogId;
        obj.FormValues = formdata;
        Esigndata.push(obj);
        var Ctrdata = {};
        Ctrdata.name = "Esigndata";
        Ctrdata.value = JSON.stringify(Esigndata);
        formdata.push(Ctrdata);
        $.ajax({
            url: "/ReportBuiderApi/EsignApproval",
            headers: {
                "Authorization": "Basic " + auth
            },
            contentType: "application/json; charset=utf-8",

            data: JSON.stringify(formdata),
            type: "Post",
            dataType: 'json',
            success: function (response) {

                SuccessStatus = response.Status;

                if (SuccessStatus == 1)
                    alert(response.Message);
            },
            failure: function (data) {
                alert("ApproveEsign Failure");
            },
            error: function (data) {
                console.log('ERROR: ', data.responseText);
            },
            complete: function (jqXHR, textStatus) {
                if (SuccessStatus == 0)
                    ViewReportEsignPopup($("#EsigntabId").val());              
            }
        });
    }

}
function OpenEsignModal(obj) {
    $("#EsignModalPopup input").each(function () {
        this.value = "";
    });
    $("#EsignModalPopup select").each(function () {
        this.value = "";
    });
    $("#EsignModalPopup textarea").each(function () {
        this.value = "";
    });
    $("#EsigntabId").val(obj.id.split('_')[1]);
    $("#EsignModalPopup").modal('show');

}
function EsignDetailsClick(e) {

    var grid = document.getElementsByClassName('e-grid')[0].ej2_instances[0];
    var Htmlstring = ""; var cellvalue;
    var rowObj = ej.base.closest(e, '.e-row').getAttribute('data-rowindex');
    var column = grid.getColumnByField('JSONString');
    var cell = grid.getCellFromIndex(rowObj, column.index);

    if (cell != null)
        cellvalue = cell.innerText;
    else {
        alert("Error While Displaying Record");
        return;
    }
    var Mainjsonstring = JSON.parse(cellvalue);
    var ConfigTablejson = Mainjsonstring.filter(element => element.name == "Form_Data");
    var ConfigTable = JSON.parse(ConfigTablejson[0].value).filter(element => element.ControlType == "TD"
        || element.ControlType == "TT" || element.ControlType == "TN" || element.ControlType == "DTT");
    for (var i = 0; i < ConfigTable.length; i++) {
        var inputVal = Mainjsonstring.filter(element => element.name == ConfigTable[i].SettingCode);
        if (ConfigTable[i].ControlType == "TD")
            inputVal = Mainjsonstring.filter(element => element.name == "hdn_" + ConfigTable[i].SettingCode);
        if (inputVal != null) {
            if (inputVal.length > 0) {
                Htmlstring += "<div class='col-sm-4'>";
                Htmlstring += "<div class='form-group'>";
                Htmlstring += "<label style='text-align: right;'>" + ConfigTable[i].ControlText + "</label>";
                Htmlstring += "<input type='text' class='form-control' style='pointer-events: none;' value='" + inputVal[0].value + "'/>";
                Htmlstring += "</div>";
                Htmlstring += "</div>";
            }
        }
    }
    for (var i = 1; i < 3; i++) {
        cell = null;
        column = grid.getColumnByField('UserName_L' + i.toString());
        cell = grid.getCellFromIndex(rowObj, column.index);
        if (cell != null) {
            if (cell.innerText != "") {
                Htmlstring += "<div class='col-sm-4'>";
                Htmlstring += "<div class='form-group'>";
                Htmlstring += "<label style='text-align: right;'>User Name Level " + i + "</label>";
                Htmlstring += "<input type='text' class='form-control' style='pointer-events: none;' value='" + cell.innerText + "'/>";
                Htmlstring += "</div>";
                Htmlstring += "</div>";
            }
        }
        column = grid.getColumnByField('LoginName_L' + i.toString());
        cell = grid.getCellFromIndex(rowObj, column.index);
        if (cell != null) {
            if (cell.innerText != "") {
                Htmlstring += "<div class='col-sm-4'>";
                Htmlstring += "<div class='form-group'>";
                Htmlstring += "<label style='text-align: right;'>Login Name  " + i + "</label>";
                Htmlstring += "<input type='text' class='form-control' style='pointer-events: none;' value='" + cell.innerText + "'/>";
                Htmlstring += "</div>";
                Htmlstring += "</div>";
            }
        }
        column = grid.getColumnByField('Comments_L' + i.toString());
        cell = grid.getCellFromIndex(rowObj, column.index);
        if (cell != null) {
            if (cell.innerText != "") {
                Htmlstring += "<div class='col-sm-12'>";
                Htmlstring += "<div class='form-group'>";
                Htmlstring += "<label style='text-align: right;'>Comments  " + i + " </label>";
                Htmlstring += "<textarea  rows='2' cols='50'  class='form-control' style='pointer-events: none;' >" + cell.innerText + "</textarea>";
                Htmlstring += "</div>";
                Htmlstring += "</div>";
            }
        }
    }

    $("#divEsignLog").html(Htmlstring);
    $("#EsignLogDetails").modal('show');
    // var url = '@Url.Action("Details", "Template")' + '/' + rowObj.data.Id;

    // window.location.rel='nofollow' href = url;

}
function EsignReportClick(e, Clsvariable) {
    var grid = document.getElementsByClassName('e-grid')[0].ej2_instances[0];
    var Htmlstring = ""; var cellvalue;

    var rowObj = ej.base.closest(e, '.e-row').getAttribute('data-rowindex');
    var column = grid.getColumnByField('JSONString');
    var cell = grid.getCellFromIndex(rowObj, column.index);

    if (cell != null) {
        var formdata = JSON.parse(cell.innerText);
        column = grid.getColumnByField('ReportName');
        cell = grid.getCellFromIndex(rowObj, column.index);
        var ReportName = cell.innerText;
        AddTab(formdata, ReportName, 0, Clsvariable)

    }


}
function RefreshEsignGrid() {

    if ($("#frmMain")[0].checkValidity() == false) {
        $("#frmMain")[0].reportValidity()
        return false;
    }
    var auth = btoa($('#hdnUserName').val() + ':' + $('#hdnPassword').val());
    var Chkpending = document.getElementById("Chkpending").checked;
    var FromDate = $('#FromDateTime').val();
    var ToDate = $('#ToDateTime').val();
    $.ajax({
        url: "/ReportBuiderApi/LoadEsignData",
        headers: {
            "Authorization": "Basic " + auth
        },
        contentType: "application/json; charset=utf-8",

        data: { "GroupId": $('#ddlGroupId').val(), "Pending": Chkpending, "Level": $('#ddlEsignLevel').val(), "FromDate": $('#FromDateTime').val(), "ToDate": $('#ToDateTime').val() },
        type: "get",
        dataType: 'json',
        cache: false,

        success: function (response) {

            var grid = document.getElementById("Grid").ej2_instances[0];
            var ResponseData = JSON.parse(response.Data);
            var newColumn = GetEsignGridColumns(response.Data_1);
            grid.changeDataSource(ResponseData, newColumn);

        },
    });
}
function GetEsignGridColumns(Columnstring) {

    var ColArray;
    if (Columnstring != null)
        ColArray = JSON.parse(Columnstring);
    var newColumn = [
        { field: 'FromDateTime', headerText: 'From DateTime', format: 'dd-MM-yyyy HH:mm', type: 'dateTime', textAlign: 'Left' },
        { field: 'ToDateTime', headerText: 'To DateTime', format: 'dd-MM-yyyy HH:mm', type: 'dateTime', textAlign: 'Left' },
        { field: 'ReportName', headerText: 'Report Name', textAlign: 'Left' },
        { field: 'Unit_Name', headerText: 'Unit Name', textAlign: 'Left', visible: false },
        { field: 'Sub_Unit_Name', headerText: 'Sub_Unit_Name', textAlign: 'Left', visible: false },
        { field: 'ProductName', headerText: 'ProductName', textAlign: 'Left', visible: false },
        { field: 'BatchNo', headerText: 'Batch No', textAlign: 'Left', visible: false },
        { field: 'LotNo', headerText: 'Lot No', textAlign: 'Left', visible: false },
        { field: 'UserName_L1', headerText: 'UserName_L1', textAlign: 'Left', visible: false },
        { field: 'LoginName_L1', headerText: 'LoginName_L1', textAlign: 'Left', visible: false },
        { field: 'Comments_L1', headerText: 'Comments_L1', textAlign: 'Left', visible: false },
        { field: 'UserName_L2', headerText: 'UserName_L2', textAlign: 'Left', visible: false },
        { field: 'LoginName_L2', headerText: 'LoginName_L2', textAlign: 'Left', visible: false },
        { field: 'Comments_L2', headerText: 'Comments_L2', textAlign: 'Left', visible: false },
        { field: 'JSONString', headerText: 'JSONString', textAlign: 'Left', visible: false },
        { template: '#template', headerText: 'Detail', textAlign: 'Left' }
    ];

    //Changing Header Text and Visiblilty of Columns according to Response
    if (ColArray != null) {
        for (var i = 0; i < ColArray.length; i++) {
            var data_filter = ColArray.filter(element => element.field == ColArray[i].field)
            if (data_filter != null) {
                var objIndex = newColumn.findIndex(element => element.field == data_filter[0].field);
                if (objIndex != null) {
                    if (objIndex > 0)
                        newColumn[objIndex].headerText = data_filter[0].headerText;
                    newColumn[objIndex].visible = data_filter[0].visible;
                }
            }
        }
    }
    return newColumn;

}
function LoadEsignGrid() {

    var auth = btoa($('#hdnUserName').val() + ':' + $('#hdnPassword').val());
    var Chkpending = document.getElementById("Chkpending").checked;
    var FromDate = $('#FromDateTime').val();
    var ToDate = $('#ToDateTime').val();
    $.ajax({
        url: "/ReportBuiderApi/LoadEsignData",
        headers: {
            "Authorization": "Basic " + auth
        },
        contentType: "application/json; charset=utf-8",

        data: { "GroupId": $('#ddlGroupId').val(), "Pending": Chkpending, "Level": $('#ddlEsignLevel').val(), "FromDate": $('#FromDateTime').val(), "ToDate": $('#ToDateTime').val() },
        type: "get",
        dataType: 'json',
        cache: false,

        success: function (response) {
            var ResponseData = JSON.parse(response.Data);
            var grid = new ej.grids.Grid({
                dataSource: ResponseData,
                allowPaging: true,
                isResponsive: true, enablePersistence: false,
                pageSettings: { pageCount: 20 },
                loadingIndicator: { indicatorType: 'Spinner' },
                toolbar: ['Search'],
                searchSettings: { operator: 'contains' },
                formatSettings: [{ name: 'Year', format: 'dd/MM/yyyy-HH:mm', type: 'date' }],
                columns: GetEsignGridColumns(response.Data_1)
            });
            grid.appendTo('#Grid');
        },
    });
}

function UserActivity() {

    var auth = btoa($('#hdnUserName').val() + ':' + $('#hdnPassword').val())
    $.ajax({
        url: "/ReportBuiderApi/UserActivity",
        headers: {
            "Authorization": "Basic " + auth
        },
        contentType: "application/json; charset=utf-8",

        type: "Get",
        dataType: 'json',
        success: function (response) {
        },
        error: function (data) {
            console.log('ERROR: ', data.responseText);
        }
    });
}

function ManageAuditTrailonload(PageName,AppUserName) {
    var formData = [];
    var Ctrdata = {};
    Ctrdata.name = "hdnPageName";
    Ctrdata.value = PageName;
    formData.push(Ctrdata);
    Ctrdata = {};
    Ctrdata.name = "CurrentUser";
    Ctrdata.value = AppUserName;
    formData.push(Ctrdata);
    var auth = btoa($('#hdnUserName').val() + ':' + $('#hdnPassword').val())
    $.ajax({
        url: "/ReportBuiderApi/ManageAuditTrail",
        headers: {
            "Authorization": "Basic " + auth
        },
        contentType: "application/json; charset=utf-8",

        data: JSON.stringify(formData),
        type: "Post",
        dataType: 'json',
        success: function (response) {
        },
        error: function (data) {
            console.log('ERROR: ', data.responseText);
        }
    });
}
