﻿

//Loading dropdown controls
function LoadDropdownControl(ControlData, PopulateControl) {


    var SettingCode = ControlData.SettingCode;
    if (SettingCode == "") {
        alert("Control Not found");
        return null;
    }

    var WebMethodName = ControlData.Webmethod;
    if (WebMethodName == "" || WebMethodName == null)
        WebMethodName = "/ReportBuiderApi/PopulateDropdown";
    var DropdownId = '#' + SettingCode;
    var SpanDropdownId = '#sp_' + SettingCode;

    var SelectText = $(DropdownId).attr('placeholder');

    if (ControlData.ControlDropDownValue != "" && ControlData.ControlDropDownValue != null)
        return;
    $(DropdownId).html('');
    options = '<option value="">' + SelectText + '</option>';
    $(SpanDropdownId).text('');
    $(DropdownId).append(options);

    if (PopulateControl != "Y") {
        return null;
    }

    //setting jsonstring of setting code row details in array
    var Ctrdata = {};
    Ctrdata.name = "ControlData";
    Ctrdata.value = JSON.stringify(ControlData);
    var formdata = $('#frmMain').serializeArray();
    formdata.push(Ctrdata);




    //getting Authorization Details
    var auth = btoa($('#hdnUserName').val() + ':' + $('#hdnPassword').val())
    var options = '';

    //Calling Ajax function
    return request = $.ajax({
        url: WebMethodName,
        headers: {
            "Authorization": "Basic " + auth
        },
        contentType: "application/json; charset=utf-8",

        data: JSON.stringify(formdata),
        type: "POST",
        dataType: 'json',
        cache: false,
        beforeSend: function () {

            $(SpanDropdownId).html('<i class="fas fa-circle-notch fa-spin"></i>  Loading...');
        },
        success: function (response) {
            $(SpanDropdownId).text('');
            if (response.Message.length > 0) {
                $(SpanDropdownId).text(response.Message);
            }
            else {
                if (response.Data.length > 0) {
                    //populating Dropdown

                    $(DropdownId).html('');
                    options = '<option value="">' + SelectText + '</option>';

                    var datatable = JSON.parse(response.Data);

                    for (var i = 0; i < datatable.length; i++) {
                        if ('TAG' in datatable[i] == true)
                            options += '<option value="' + datatable[i]["VALUEID"] + '" TAG="' + datatable[i]["TAG"] + '" >' + datatable[i]["NAME"] + '</option>';
                        else
                            options += '<option value="' + datatable[i]["VALUEID"] + '"  >' + datatable[i]["NAME"] + '</option>';
                    }
                    $(DropdownId).append(options);
                    if (datatable.length > 0) {
                        if (datatable.length == 1) {
                            $(DropdownId).val(datatable[0]["VALUEID"]);
                            $(DropdownId).trigger('change');
                        }
                    }

                }
            }
        },
        error: function (jqXHR) {
            alert(jqXHR);
        },
        complete: function (jqXHR, textStatus) {


        }
    });

}
//Loading MultiSelect DropDown control
function LoadMuliSelectDropdownControl(ControlData, PopulateControl) {

    var SettingCode = ControlData.SettingCode;
    if (SettingCode == "") {
        alert("Control Not found");
        return null;
    }
    if (PopulateControl != "Y") {
        return null;
    }
    var WebMethodName = ControlData.Webmethod;
    if (WebMethodName == "" || WebMethodName == null)
        WebMethodName = "/ReportBuiderApi/PopulateDropdown";
    var DropdownId = '#ddl_' + SettingCode;
    var SpanDropdownId = '#sp_' + SettingCode;

    //setting jsonstring of setting code row details in array
    var Ctrdata = {};
    Ctrdata.name = "ControlData";
    Ctrdata.value = JSON.stringify(ControlData);
    var formdata = $('#frmMain').serializeArray();
    formdata.push(Ctrdata);




    //getting Authorization Details
    var auth = btoa($('#hdnUserName').val() + ':' + $('#hdnPassword').val())
    var options = '';
    var SelectText = $(DropdownId).attr('placeholder');


    //Calling Ajax function
    return $.ajax({
        url: WebMethodName,
        headers: {
            "Authorization": "Basic " + auth
        },
        contentType: "application/json; charset=utf-8",

        data: JSON.stringify(formdata),
        type: "POST",
        dataType: 'json',
        beforeSend: function () {

            $(SpanDropdownId).html('<i class="fas fa-circle-notch fa-spin"></i>  Loading...');

        },
        success: function (response) {
            $(SpanDropdownId).text('');
            if (response.Message.length > 0) {
                $(SpanDropdownId).text(response.Message);
            }
            else {
                if (response.Data.length > 0) {
                    //populating Dropdown


                    var datatable = JSON.parse(response.Data);
                    if (document.getElementById(DropdownId.replace("#", "")).ej2_instances != null) {

                        var msObject = document.getElementById(DropdownId.replace("#", "")).ej2_instances[0];
                        msObject.dataSource = datatable;

                    }
                    else {
                        //initiate the MultiSelect
                        var msObject = new ej.dropdowns.MultiSelect({
                            // bind the sports Data to datasource property
                            dataSource: datatable,
                            mode: 'CheckBox',
                            showSelectAll: true,
                            popupHeight: '200px',
                            // maps the appropriate column to fields property
                            fields: { text: 'NAME', value: 'VALUEID' },
                            //set the placeholder to MultiSelect input
                            placeholder: SelectText,
                            allowObjectBinding: true,
                            //enable custom Value option with multislect

                        });
                        msObject.appendTo(DropdownId);
                    }
                    // render initialized multiSelect


                }
            }
        },
        error: function (jqXHR) {
            alert(jqXHR);
        },
        complete: function (jqXHR, textStatus) {
        }
    });
}

// Looping Through Controls of the Form and poplating it
function GetControls() {
    //Getting Controls for populating dropdown
    var formdata = JSON.stringify($('#frmMain').serializeArray());
    const jsonArray = JSON.parse(formdata)
    const InputVarData = JSON.parse($('#Form_Data').val());
    var promises = [];

    for (var i = 0; i < jsonArray.length; i++) {
        try {

            var request = null;
            if ($('#' + jsonArray[i].name) != null) {
                if ($('#' + jsonArray[i].name) != null) {
                    var FilteredData = InputVarData.filter(function (item) { return (item.SettingCode == jsonArray[i].name) });
                    var NodeName = $('#' + jsonArray[i].name)[0].nodeName;
                    if (NodeName == null)
                        continue;
                    if (FilteredData == null)
                        continue;
                    if (NodeName.toUpperCase() == "SELECT" && FilteredData[0].ControlType == "TD")//getting only select inputs
                    {
                        if (FilteredData[0].SqlQuery != "" && FilteredData[0].SqlQuery != null)
                            request = LoadDropdownControl(FilteredData[0], FilteredData[0].PopluateOnload);
                        else if (FilteredData[0].SourceId != "" && FilteredData[0].SourceId != null)
                            request = LoadDropdownControl(FilteredData[0], FilteredData[0].PopluateOnload);
                        if (request != null)
                            promises.push(request);
                    }
                    else if (NodeName.toUpperCase() == "INPUT" && FilteredData[0].ControlType == "TDM")//getting only select inputs
                    {

                        if (FilteredData[0].ControlType == "TDM") {
                            if (FilteredData[0].SqlQuery != "" && FilteredData[0].SqlQuery != null)
                                request = LoadMuliSelectDropdownControl(FilteredData[0], FilteredData[0].PopluateOnload);
                            else if (FilteredData[0].SourceId != "" && FilteredData[0].SourceId != null)
                                request = LoadMuliSelectDropdownControl(FilteredData[0], FilteredData[0].PopluateOnload);
                            if (request != null)
                                promises.push(request);
                        }
                    }

                }
            }
        } catch (e) {

        }
    }
    Promise.all(promises).then(function () {


        console.log("This is completed");
    });
    //$.when.apply(null, promises).done(function () {
    //    alert('All done')
    //})
    //Promise.all(promises)
    //    .then(responseList => {
    //        console.dir(responseList)
    //    })
}

//Populating Combo onchange of Another Controls Selection
//controlId=this,objMainIds=Comma Separated Controls
function onchangeComboPopulate(controlId, objMainIds) {
    //populating other combos on change
    var objMainIds = objMainIds.split(",");
    for (var i = 0; i < objMainIds.length; i++) {

        try {

            var InputVarData = JSON.parse($('#Form_Data').val());

            var FilteredData = InputVarData.filter(function (item) { return (item.SettingCode == objMainIds[i]) });
            if (FilteredData != null) {
                if (FilteredData[0].ControlType == "TDM")
                    LoadMuliSelectDropdownControl(FilteredData[0], 'Y');
                else
                    LoadDropdownControl(FilteredData[0], 'Y');
            }
        } catch (e) {

        }
    }
}
//onchangeTextPopulate controlId=this,objMainIds=Controls To Populate
//onchangeTextPopulate This Function will populate text box Control
function onchangeTextPopulate(controlId, objMainIds) {
    //populating Text controls from DB Query

    try {

        var InputVarData = JSON.parse($('#Form_Data').val());
        var FilteredData = InputVarData.filter(function (item) { return (item.SettingCode == controlId.id) });
        if (FilteredData != null) {
            LoadTextControls(FilteredData[0], objMainIds);
        }
    } catch (e) {


    }
}
function ClearControl(controlId, ClearObjIds) {

    var objClearCtrIds = ClearObjIds.split(",");
    if (objClearCtrIds.length > 0) {
        for (var i = 0; i < objClearCtrIds.length; i++) {
            $("#" + objClearCtrIds[i]).html('');
        }
    }
    else {
        if ($("#" + ClearObjIds) != null)
            $("#" + ClearObjIds).html('')
    }
}
//Clearing Controls onchange or Onclick
//controlId = this,objResetIds=Controls to Reset values,ClearObjIds=Controls to be Cleared
function ResetControls(controlId, objResetIds, ClearObjIds = "") {

    //ClearObjIds can be blank it is used if the Dropdown option needs to cleared
    var objCtrIds; var objClearCtrIds

    objCtrIds = objResetIds.split(",");

    objClearCtrIds = ClearObjIds.split(",");

    var SelectText = "";
    if (objCtrIds.length > 0) {

        for (var i = 0; i < objCtrIds.length; i++) {
            if (objCtrIds[i] == "")
                continue;
            SelectText = "";
            var NodeName = $('#' + objCtrIds[i])[0].nodeName;

            if (NodeName != null) {
                if (NodeName != null && NodeName.toUpperCase() == "SELECT") {
                    $('#' + objCtrIds[i]).prop('selectedIndex', 0);

                }
            }
            $("#" + objCtrIds[i]).val('');
        }
    }
    else {
        if ($("#" + objResetIds) != null)
            $("#" + objResetIds).val('')
    }
    //Clearing Objects
    if (objClearCtrIds.length > 0) {

        for (var i = 0; i < objClearCtrIds.length; i++) {
            if (objClearCtrIds[i] == "")
                continue;
            SelectText = "";
            var NodeName = $('#' + objClearCtrIds[i])[0].nodeName;

            if (NodeName != null) {
                if (NodeName != null && NodeName.toUpperCase() == "SELECT") {

                    if (ClearObjIds != "" && ClearObjIds.includes(objClearCtrIds[i])) {
                        SelectText = $('#' + objClearCtrIds[i]).attr('placeholder');
                        $('#' + objClearCtrIds[i]).html('');
                        options = '<option value="">' + SelectText + '</option>';
                        $('#' + objClearCtrIds[i]).append(options);
                    }
                }
            }
            $("#" + objClearCtrIds[i]).val('');
        }
    }
    else {
        if ($("#" + ClearObjIds) != null)
            $("#" + ClearObjIds).val('')
    }
}

//objMainIds=Controls to Validate
function ValidateControls(controlId, objMainIds) {
    // Validating Controls based on control ids given
    // MultiSelect is pending the Ids have to hardcoded with name
    var objCtrIds; var alertMsg = '';
    var summary = '';
    var divRpt = '#divRptBldrFormAlert'
    if (objMainIds.includes(",") == true) {
        objCtrIds = objMainIds.split(",");
    }

    if (objMainIds.includes(",") == true && objCtrIds.length > 0) {

        for (var i = 0; i < objCtrIds.length; i++) {
            var Control = $('#' + objCtrIds[i]);
            var SelectText = Control.attr('placeholder');
            if (Control.val() == '') {
                summary += ' <div class="col-lg-12">' + SelectText + '</div>';
            }
        }
    }
    else {

        var Control = $("#" + objMainIds);
        var SelectText = Control.attr('placeholder');
        if (Control.val() == '') {
            summary += ' <div class="col-lg-12">' + SelectText + '</div>';
        }
    }
    if (summary != '') {
        $(divRpt).html(summary);
        $('#modalRptBldrFormAlert').modal('show');
        return false
    }
    else
        return true
}
//Clearing div of summary Alert of Required Fields
function btnmodalRptFormAlertClose(objid) {

    $('#' + objid).html('');
}
//populating controls from Dropdown Tags with ^ delimiter
function onchangeJSTextPopulate(controlId, objMainIds) {
    
    var objCtrIds; var objtagIds;
    var tag = controlId.options[controlId.selectedIndex].getAttribute('tag');
    if (tag == null)
        return;
    if (objMainIds.includes(",") == true) {
        objCtrIds = objMainIds.split(",");
        objtagIds = tag.split("^");
    }
    try {
        var strValues = "";
        if (tag != "" && tag != null) {
            if (tag.includes("^") == true) {
                if (objCtrIds.length > 0) {

                    for (var i = 0; i < objCtrIds.length; i++) {
                        strValues = tag.split("^")[i];
                        //  $("#" + objCtrIds[i]).val(strValues)
                        document.getElementById(objCtrIds[i]).value = strValues;
                        document.getElementById(objCtrIds[i]).setCustomValidity('')
                        if (document.getElementById("hdn_" + objCtrIds[i]) != null) {
                            document.getElementById("hdn_"+objCtrIds[i]).value = strValues;
                        }

                    }
                }
            }
            else {
                document.getElementById(objMainIds).setCustomValidity('')
                $("#" + objMainIds).val(tag);
                if (document.getElementById("hdn_" + objMainIds) != null) {
                    document.getElementById("hdn_" + objMainIds).value = tag;
                }
            }
        }

    } catch (e) {
        alert("onchangeJSTextPopulate:" + e)
    }

}

function FormatDate(obj, dtformat) {
    debugger;
    var dateFormat = (dtformat.split(" ")[0]).toUpperCase() + " " + (dtformat.split(" ")[1]);

    var newDate = moment(obj.value, dtformat).toDate();
    obj.value = moment(newDate).format(dateFormat);
}

//controlId = this,objMainIds=Control to Populate,ValidateControlIds=Validating Controls on Search click
function SearchClick(controlId, objMainId, ValidateControlIds = '') {

    var validflg = true;
    if (ValidateControlIds != "") {
        validflg = ValidateControls(controlId, ValidateControlIds)
    }
    if (validflg == false)
        return;
    try {
        var InputVarData = JSON.parse($('#Form_Data').val());

        var FilteredData = InputVarData.filter(function (item) { return (item.SettingCode == objMainId) });
        if (FilteredData != null) {
            LoadDropdownControl(FilteredData[0], 'Y');
        }
    } catch (e) {

    }

}
//This Function will populate text box Control
function LoadTextControls(ControlData, objMainIds) {

    var Ctrdata = {};
    Ctrdata.name = "ControlData";
    Ctrdata.value = JSON.stringify(ControlData);
    var formdata = $('#frmMain').serializeArray();
    formdata.push(Ctrdata);
    var SettingCode = ControlData.SettingCode;
    if (SettingCode == "" && SettingCode != null) {
        alert("Control Not found");
        return;
    }

    var WebMethodName = ControlData.Webmethod;
    if (WebMethodName == "" || WebMethodName == null)
        WebMethodName = "/ReportBuiderApi/GetTextData";

    var SpanCtrId = '#sp_' + SettingCode;
    var auth = btoa($('#hdnUserName').val() + ':' + $('#hdnPassword').val())
    var options = '';

    $(SpanCtrId).text('');

    $.ajax({
        url: WebMethodName,
        headers: {
            "Authorization": "Basic " + auth
        },
        contentType: "application/json; charset=utf-8",

        data: JSON.stringify(formdata),
        type: "POST",
        dataType: 'json',
        success: function (response) {

            if (response.Message.length > 0) {
                $(SpanCtrId).text(response.Message);
            }
            else {
                if (response.Data.length > 0) {

                    var dt = JSON.parse(response.Data);

                    var ControldIds = objMainIds.split(",");
                    for (var i = 0; i < ControldIds.length; i++) {
                        var ControlId = '#' + ControldIds[i];
                        $(ControlId).val(dt[0]["Col" + i.toString()]);
                        if (document.getElementById("hdn_" + ControldIds[i]) != null) {
                            document.getElementById("hdn_" + ControldIds[i]).value = strValues;
                        }
                    }
                }
            }
        },
        error: function (jqXHR) {
            alert(jqXHR);
        },
    });

}
// this gives only Response from the Query Configured in Config DB with Respect to the ControlId given
function GetDataTable(controlId) {

    try {


        var InputVarData = JSON.parse($('#Form_Data').val());
        var FilteredData = InputVarData.filter(function (item) { return (item.SettingCode == controlId) });
        if (FilteredData == null)
            return "Error in GetDataTable";
        var Ctrdata = {};
        Ctrdata.name = "ControlData";
        Ctrdata.value = JSON.stringify(FilteredData[0]);
        var formdata = $('#frmMain').serializeArray();
        formdata.push(Ctrdata);
        var SettingCode = FilteredData[0].SettingCode;
        if (SettingCode == "" && SettingCode != null) {
            alert("Control Not found");
            return;
        }

        var WebMethodName = FilteredData[0].Webmethod;
        if (WebMethodName == "" || WebMethodName == null)
            WebMethodName = "/ReportBuiderApi/GetDataTable";

        var auth = btoa($('#hdnUserName').val() + ':' + $('#hdnPassword').val())


        return $.ajax({
            url: WebMethodName,
            headers: {
                "Authorization": "Basic " + auth
            },
            contentType: "application/json; charset=utf-8",

            data: JSON.stringify(formdata),
            type: "POST",
            dataType: 'json'
        });
    } catch (e) {
        alert(e.Message);
    }
}
function ClearTargetedControl(objCtrId) {

    $("#" + objCtrId).html('');
}
function LoadGroupControl(SettingCode) {


    var WebMethodName = "/ReportBuiderApi/PopulateGroup";

    var DropdownId = '#' + SettingCode;
    var SpanDropdownId = '#sp_' + SettingCode;

    var SelectText = $(DropdownId).attr('placeholder');


    $(DropdownId).html('');
    options = '<option value="">' + SelectText + '</option>';
    $(SpanDropdownId).text('');
    $(DropdownId).append(options);

    //getting Authorization Details
    var auth = btoa($('#hdnUserName').val() + ':' + $('#hdnPassword').val())
    var options = '';

    //Calling Ajax function
    return request = $.ajax({
        url: WebMethodName,
        headers: {
            "Authorization": "Basic " + auth
        },
        contentType: "application/json; charset=utf-8",

        type: "get",
        dataType: 'json',
        cache: false,
        beforeSend: function () {

            $(SpanDropdownId).html('<i class="fas fa-circle-notch fa-spin"></i>  Loading...');
        },
        success: function (response) {
            $(SpanDropdownId).text('');
            if (response.Message.length > 0) {
                $(SpanDropdownId).text(response.Message);
            }
            else {
                if (response.Data.length > 0) {
                    //populating Dropdown

                    $(DropdownId).html('');
                    options = '<option value="">' + SelectText + '</option>';

                    var datatable = JSON.parse(response.Data);
                    var Parent_data_filter = datatable.filter(element => element.GroupLevel == "0")
                    Parent_data_filter.sort(function (a, b) { return a.GroupSrno - b.GroupSrno });
                   // var data_Subfilter = datatable.filter(element => element.GroupLevel == "1")

                    
                    for (var i = 0; i < Parent_data_filter.length; i++) {

                        var Sub_data_filter = datatable.filter(element => element.ParentGroupId == Parent_data_filter[i].GroupId)
                        if (Sub_data_filter != null && Sub_data_filter.length>0) {
                            Sub_data_filter.sort(function (a, b) { return a.GroupSrno - b.GroupSrno });
                            options += '<optgroup  label="' + Parent_data_filter[i]["GroupName"] + '"  >';
                            for (var j = 0; j < Sub_data_filter.length; j++) {
                                options += '<option value="' + Sub_data_filter[j]["GroupId"] + '"  >' + Sub_data_filter[j]["GroupName"] + '</option>';
                            }
                            options += '</optgroup>';
                        }
                        else {
                            options += '<option value="' + Parent_data_filter[i]["GroupId"] + '">' + Parent_data_filter[i]["GroupName"] + '</option>';
                        }
                    }
                    $(DropdownId).append(options);


                }
            }
        },
        error: function (jqXHR) {
            alert(jqXHR);
        },
        complete: function (jqXHR, textStatus) {


        }
    });

}
//controlId = this,ShiftId=ShiftDropdown,FromDate=Shift Date,ShiftStartTime,ShiftEndTime=Control To Populate
function PopulateShiftTime(controlId, ShiftId,FromDate, ShiftStartTime, ShiftEndTime) {

    debugger;

   

    var WebMethodName = "/ReportBuiderApi/PopulateShiftTime";
    var ShiftcontrolObj = document.getElementById(ShiftId);
    var DropdownId = '#' + ShiftId;
    var SpanDropdownId = '#sp_' + ShiftId;
    var DTFormat = $('#hdnfrmt_' + FromDate).val();
    var SelectText = $('#' + FromDate).attr('placeholder');
    $('#sp_' + FromDate).text('');
    $(SpanDropdownId).text('');
    if ($('#' + FromDate).val() == "") {
        $('#sp_' + FromDate).text(SelectText);
        return;
    }
    SelectText = $(DropdownId).attr('placeholder');
    if (ShiftcontrolObj.value == "") {
        $(SpanDropdownId).text('Select Shift');
        return;
    }
    
   
    var ShiftFormat = $('#hdnfrmt_' + ShiftStartTime).val();
    var Shifttag = ShiftcontrolObj.options[ShiftcontrolObj.selectedIndex].getAttribute('tag');
    var ShifDate = $('#' + FromDate).val();
    $(SpanDropdownId).text('');
    

    //getting Authorization Details
    var auth = btoa($('#hdnUserName').val() + ':' + $('#hdnPassword').val())
    var options = '';

    //Calling Ajax function
    return request = $.ajax({
        url: WebMethodName,
        headers: {
            "Authorization": "Basic " + auth
        },
        contentType: "application/json; charset=utf-8",

        type: "get",
        dataType: 'json',
        data: { ShiftTime: Shifttag, ShifDate: ShifDate, DTFormat: DTFormat, ShiftFormat: ShiftFormat },
        cache: false,
        beforeSend: function () {

            $(SpanDropdownId).html('<i class="fas fa-circle-notch fa-spin"></i>  Loading...');
        },
        success: function (response) {
            debugger;
            $(SpanDropdownId).text('');
            if (response.Message.length > 0) {
                $(SpanDropdownId).text(response.Message);
            }
            else {
                if (response.Data.length > 0) {
                    var responseString = JSON.parse(response.Data);
                    //populating Dropdown
                    $('#ShiftStartTime').val(responseString.ShiftStartDate);
                    $('#ShiftEndTime').val(responseString.ShiftEndDate);


                }
            }
        },
        error: function (jqXHR) {
            alert(jqXHR);
        },
        complete: function (jqXHR, textStatus) {


        }
    });

}






